package com.bxm.adxcounter.service.listeners.sdk;

import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.adxcounter.service.model.events.sdk.SdkExtBindEvent;
import com.bxm.adxcounter.service.service.UserService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * 扩展数据处理器
 *
 * @author allen
 * @date 2020-07-16
 * @since 1.0
 */
@Slf4j
@Service
public class SdkExtBindingEventListener implements EventListener<SdkExtBindEvent> {

    private final ApplicationGlobalConfig config;
    private final UserService userService;
    private UserIntegration userIntegration;

    public SdkExtBindingEventListener(ApplicationGlobalConfig config, UserService userService,
                                      UserIntegration userIntegration) {
        this.config = config;
        this.userService = userService;
        this.userIntegration = userIntegration;
    }

    @Override
    @Subscribe
    public void consume(SdkExtBindEvent event) {
        SdkPublicDTO endpoint = event.getEndpoint();
        String appid = endpoint.getAppid();
        if (!config.getApp().getEnableExtBindingAppId().contains(appid)) {
            log.info("{} is not enable ext-binding.", appid);
            return;
        }
        Map<String, String> extForMap = endpoint.getExtForMap();
        if (MapUtils.isEmpty(extForMap)) {
            return;
        }
        String cuid = extForMap.get(SdkEquipmentDTO.EXT_CUID);
        String uid = userIntegration.getUid(endpoint);
        userService.setUserMapping(appid, uid, cuid);
    }
}
