package com.bxm.adxcounter.service.listeners.task;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.constant.redis.TaskCounterField;
import com.bxm.adx.facade.rule.task.Task;
import com.bxm.adxcounter.service.common.Constant;
import com.bxm.adxcounter.service.listeners.TaskDotSupport;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.task.TaskSucceedEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 任务埋点-唤醒成功<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/2 14:49
 */
@Slf4j
@Service
public class TaskSucceedEventListener extends TaskDotSupport implements EventListener<TaskSucceedEvent> {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    @Qualifier("jedisCounter")
    private Counter counter;

    @Override
    @Subscribe
    public void consume(TaskSucceedEvent event) {
        TaskEndpoint endpoint = event.getEndpoint();
        String taskIdStr = endpoint.getTaskId();

        if(StringUtils.isEmpty(taskIdStr)){
            log.warn("taskIdStr is empty！appId={}", endpoint.getAppId());
            return ;
        }
        //任务原始信息
        Task task = fetcher.hfetch(AdxKeyGenerator.Task.getAllList(), taskIdStr, Task.class);
        if (task == null){
            log.warn("任务信息（{}）为空！", taskIdStr);
            return ;
        }
        if (Task.STATUS_OPEN != task.getStatus()){
            log.warn("任务信息（{}）不是开启状态，无需统计！", taskIdStr);
            return ;
        }
        Long taskId = Long.valueOf(taskIdStr);
        String dmy = DateHelper.format(new Date(), DateHelper.PATTERN_STR8);
        //任务按日
        {
            //Key
            KeyGenerator taskKeyGenerator = AdxKeyGenerator.Task.getCounter(taskId, dmy);
            //增加 唤醒成功量
            counter.hincrementAndGet(taskKeyGenerator, TaskCounterField.SUCCEED_WAKES, Constant.EXPIRE_TASK_DAY);
        }

        //打点
        super.consume(event.getDotMtEnums(), endpoint);
    }
}
