package com.bxm.adxcounter.service.model.endpoint;

import java.io.Serializable;
import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import com.bxm.adxcounter.facade.model.AbstractCounterDTO;

import lombok.Data;

/**
 * 公共参数<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 13:53
 */
@Data
public abstract class AbstractEndpoint implements Serializable {

    private static final long serialVersionUID = -4805979249918133754L;
    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;

    /**
     * 请求日期时间戳
     */
    private Long timestamp;
    /**
     * 用户IP地址
     */
    private String ip;
    /**
     * User-Agent
     */
    private String ua;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * 系统类型
     * 0:未知
     * 1:安卓
     * 2:IOS
     */
    private String os;
    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * IMEI，所属安卓
     */
    private String imeiMd5;
    /**
     * 安卓ID，所属安卓
     */
    private String androidId;
    /**
     * 安卓ID，所属安卓
     */
    private String androidIdMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * IDFA，所属IOS
     */
    private String idfaMd5;
    /**
     * 设备品牌,如：华为
     */
    private String deviceBrand;
    /**
     * 设备型号,如：华为 mate 10 pro
     */
    private String deviceModel;
    /**
     * 联网方式
     * 0:未知
     * 1:以太网
     * 2:Wifi网络
     * 3:蜂窝数据网络-2G
     * 4:蜂窝数据网络-3G
     * 5:蜂窝数据网络-4G
     * 6:蜂窝数据网络-5G
     * 7:蜂窝数据网络-未知
     */
    private String netType;
    /**
     * 经度
     */
    private String longitude;
    /**
     * 纬度
     */
    private String latitude;

    /**
     * 参数转换<br/>
     */
    public void of(AbstractCounterDTO counter){
        if(StringUtils.isBlank(counter.getT())){
            this.setTimestamp(System.currentTimeMillis());
        }else{
            try {
                this.setTimestamp(new BigDecimal(counter.getT()).longValue());
            }catch (Exception e){
                this.setTimestamp(System.currentTimeMillis());
            }
        }
        this.setIp(counter.getIp());
        this.setUa(counter.getUa());
        this.setMac(counter.getMac());
        this.setOs(counter.getOs());
        this.setImei(counter.getImei());
        this.setImeiMd5(counter.getImei_md5());
        this.setAndroidId(counter.getAnid());
        this.setAndroidIdMd5(counter.getAnid_md5());
        this.setOaid(counter.getOaid());
        this.setIdfa(counter.getIdfa());
        this.setIdfaMd5(counter.getIdfa_md5());
        this.setDeviceBrand(counter.getDevb());
        this.setDeviceModel(counter.getDevm());
        this.setNetType(counter.getNet());
        this.setLongitude(counter.getLon());
        this.setLatitude(counter.getLat());
    }
}
