package com.bxm.adxcounter.service.model.endpoint;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 打点参数-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 14:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AdxEndpoint extends AbstractEndpoint {

    private static final long serialVersionUID = -6721458464992101143L;

    /**
     * 变现猫竞价ID
     */
    private String bxmBidId;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 广告平台ID
     */
    private String dspId;
    /**
     * 创意ID
     */
    private String createId;
    /**
     * 本次赢价（单位：厘）
     */
    private Double winPrice;
    /**
     * 状态
     */
    private String status;
    /**
     * 活动ID
     */
    private String activityId;
    /**
     * 投放场景类型
     */
    private String sceneType;
}
