package com.bxm.adxcounter.service.model.endpoint;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 打点参数-SDK<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 14:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SdkEndpoint extends AbstractEndpoint {

    private static final long serialVersionUID = -4805979249918133754L;

    /**
     * SDK版本号
     */
    private String sdkVersion;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 第三方SDK类型
     * 1：穿山甲
     * 2：广点通
     * 3：变现猫
     * PositionSdkConfigChannelEnum
     */
    private String thirdSdkType;

    /**
     * 错误代码
     */
    private String errorCode;
    /**
     * 第三方错误代码
     */
    private String thirdErrorCode;
}
