package com.bxm.adxcounter.service.model.events.sdk;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.NoneListenerEvent;

import lombok.Getter;

/**
 * 埋点事件-SDK通用<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 15:10
 */
public class SdkGeneralEvent extends NoneListenerEvent {

    private static final long serialVersionUID = -3357221270145808049L;

    @Getter
    private final SdkEndpoint endpoint;
    @Getter
    private final DotMtEnum[] dotMtEnums;

    public SdkGeneralEvent(Object source, SdkEndpoint endpoint, DotMtEnum... dotMtEnums) {
        super(source);
        this.endpoint = endpoint;
        this.dotMtEnums = dotMtEnums;
    }
}