package com.bxm.adxcounter.service.service;

import com.bxm.adxcounter.facade.model.UserData;

import java.util.List;

/**
 * @author allen
 * @date 2020-07-10
 * @since 1.0
 */
public interface UserService {

    /**
     * 记录今日播放完成次数
     */
    void plusPayVideoFinished(String positionId, String uid);

    /**
     * 根据应用ID查询
     * @param appId 应用ID
     * @param cuid APP自定义用户ID
     * @param date 日期，只支持 yyyyMMdd
     * @return 播放完成次数
     */
    long getPayVideoFinishedByAppId(String appId, String cuid, String date);

    /**
     * 批量查询指定应用 自定义用户ID 的用户统计数据
     * @param appId 应用ID
     * @param cuids 自定义用户ID
     * @param date 日期
     * @return 用户统计数据
     */
    List<UserData> getPayVideoFinishedByAppId(String appId, String[] cuids, String date);

    /**
     * 设置用户映射
     * @param appId 应用ID
     * @param uid 变现猫用户ID
     * @param cuid APP自定义用户ID
     */
    void setUserMapping(String appId, String uid, String cuid);
}
