package com.bxm.adxcounter.service.service.impl;

import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.events.adx.AdxGeneralEvent;
import com.bxm.adxcounter.service.service.AdxEndpointService;

import lombok.extern.slf4j.Slf4j;

/**
 * 端点服务-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:46
 */
@Slf4j
@Service
public class AdxEndpointServiceImpl extends AbstractEndpointServiceImpl implements AdxEndpointService {
    
    @Override
    public ResponseEntity post(AdxMtEnum mtEnum, AdxEndpoint endpoint) {
        switch (mtEnum) {
            case _OTHER: {
                //非法埋点
                return ResponseEntity.badRequest().body("mt不匹配");
            }
            default: {
                //不做任何处理的埋点
                asyncEventPark.post(new AdxGeneralEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            }
        }
        return ResponseEntity.ok().build();
    }
}
