/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.common.transfer;

import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AdxDecrypt {
    private static final String KEY_ALGORITHM = "AES";

    public static String encrypt(String content, String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        cipher.init(1, sKey);
        byte[] result = cipher.doFinal(byteContent);
        return AdxDecrypt.parseByte2HexStr(result);
    }

    public static String decrypt(String encryptContent, String key) throws Exception {
        byte[] content = AdxDecrypt.parseHexStr2Byte(encryptContent);
        if (content == null) {
            return null;
        }
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, sKey);
        byte[] result = cipher.doFinal(content);
        return new String(result);
    }

    private static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    private static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int num = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 2), 16);
            result[i] = (byte)num;
        }
        return result;
    }
}

