/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.JsonHelper;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkDotSupport {
    private static final Logger log = LoggerFactory.getLogger(SdkDotSupport.class);
    private static final String DEF_COUNTRY_CODE = "00";
    private static final String DEF_CITY_CODE = "000000";
    @Resource(name="asyncDotSdk")
    private AsyncDot asyncDot;

    public void consume(SdkEquipmentDTO endpoint, IP ip) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("mt", DotMtEnum._16005.getDotMt());
        parameter.put("t", endpoint.getTimestamp());
        parameter.put("ip", endpoint.getIp());
        parameter.put("mac", endpoint.getMac());
        parameter.put("os", endpoint.getOs());
        parameter.put("osv", endpoint.getOsv());
        parameter.put("imei", endpoint.getImei());
        parameter.put("imei_md5", endpoint.getImei_md5());
        parameter.put("anid", endpoint.getAnid());
        parameter.put("anid_md5", endpoint.getAnid_md5());
        parameter.put("oaid", endpoint.getOaid());
        parameter.put("idfa", endpoint.getIdfa());
        parameter.put("idfa_md5", endpoint.getIdfa_md5());
        parameter.put("devid", endpoint.getDevid());
        parameter.put("devb", endpoint.getDevb());
        parameter.put("devm", endpoint.getDevm());
        parameter.put("devt", endpoint.getDevt());
        parameter.put("devsh", endpoint.getDevsh());
        parameter.put("devsw", endpoint.getDevsw());
        parameter.put("memory", endpoint.getMemory());
        parameter.put("storage", endpoint.getStorage());
        parameter.put("cpum", endpoint.getCpum());
        parameter.put("isp", endpoint.getIsp());
        parameter.put("net", endpoint.getNet());
        parameter.put("lon", endpoint.getLon());
        parameter.put("lat", endpoint.getLat());
        parameter.put("sdkv", endpoint.getSdkv());
        parameter.put("appl", endpoint.getAppl());
        parameter.put("pkn", endpoint.getPkn());
        parameter.put("appid", endpoint.getAppid());
        if (null != ip) {
            String regionCode = StringUtils.defaultIfEmpty((String)ip.getRegioncode(), (String)DEF_CITY_CODE);
            parameter.put("country", StringUtils.defaultIfEmpty((String)ip.getCountrycode(), (String)DEF_COUNTRY_CODE));
            parameter.put("province", this.getProvinceCode(regionCode));
            parameter.put("city", regionCode);
        }
        this.asyncDot.asyncDotPostForm(parameter);
    }

    private String getProvinceCode(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)2), (int)6, (String)"0");
    }

    public void consume(DotMtEnum[] dotMtEnums, SdkEndpoint endpoint) {
        if (dotMtEnums.length > 1) {
            for (DotMtEnum dotMtEnum : dotMtEnums) {
                this.asyncDotGet(dotMtEnum, endpoint);
            }
        } else {
            this.asyncDotGet(dotMtEnums[0], endpoint);
        }
    }

    private void asyncDotGet(DotMtEnum dotMtEnum, SdkEndpoint endpoint) {
        if (dotMtEnum == DotMtEnum._OTHER) {
            return;
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("mt", dotMtEnum.getDotMt());
        parameter.put("t", endpoint.getTimestamp());
        parameter.put("os", endpoint.getOs());
        parameter.put("sdkv", endpoint.getSdkVersion());
        parameter.put("imei", endpoint.getImei());
        parameter.put("idfa", endpoint.getIdfa());
        parameter.put("ip", endpoint.getIp());
        parameter.put("ua", endpoint.getUa());
        parameter.put("posid", endpoint.getPositionId());
        parameter.put("code", endpoint.getErrorCode());
        parameter.put("tcode", endpoint.getThirdErrorCode());
        parameter.put("type", endpoint.getThirdSdkType());
        if (log.isDebugEnabled()) {
            log.debug("dot:{}", (Object)JsonHelper.convert(parameter));
        }
        this.asyncDot.asyncDotPostForm(parameter);
    }
}

