/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.utils.JsonHelper;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDotSupport {
    private static final Logger log = LoggerFactory.getLogger(TaskDotSupport.class);
    @Resource
    private AsyncDot asyncDot;

    public void consume(DotMtEnum[] dotMtEnums, TaskEndpoint endpoint) {
        if (dotMtEnums.length > 1) {
            for (DotMtEnum dotMtEnum : dotMtEnums) {
                this.asyncDotGet(dotMtEnum, endpoint);
            }
        } else {
            this.asyncDotGet(dotMtEnums[0], endpoint);
        }
    }

    private void asyncDotGet(DotMtEnum dotMtEnum, TaskEndpoint endpoint) {
        if (dotMtEnum == DotMtEnum._OTHER) {
            return;
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("bidid", endpoint.getBxmBidId());
        parameter.put("tagid", endpoint.getPositionId());
        parameter.put("t", endpoint.getTimestamp());
        parameter.put("mt", dotMtEnum.getDotMt());
        parameter.put("imei", endpoint.getImei());
        parameter.put("imei_md5", endpoint.getImeiMd5());
        parameter.put("anid", endpoint.getAndroidId());
        parameter.put("anid_md5", endpoint.getAndroidIdMd5());
        parameter.put("oaid", endpoint.getOaid());
        parameter.put("idfa", endpoint.getIdfa());
        parameter.put("idfa_md5", endpoint.getIdfaMd5());
        parameter.put("ip", endpoint.getIp());
        parameter.put("ua", endpoint.getUa());
        parameter.put("mac", endpoint.getMac());
        parameter.put("os", endpoint.getOs());
        parameter.put("devm", endpoint.getDeviceModel());
        parameter.put("brand", endpoint.getDeviceBrand());
        parameter.put("net_type", endpoint.getNetType());
        parameter.put("dspid", endpoint.getDspId());
        parameter.put("taskid", endpoint.getTaskId());
        parameter.put("appid", endpoint.getAppId());
        if (log.isDebugEnabled()) {
            log.debug("dot:{}", (Object)JsonHelper.convert(parameter));
        }
        this.asyncDot.asyncDotGet(parameter);
    }
}

