/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners.adx;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.sdk.SdkGeneralEvent;
import com.bxm.adxcounter.service.service.UserService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserPlayVideoFinishedEventListener
implements EventListener<SdkGeneralEvent> {
    private static final Logger log = LoggerFactory.getLogger(UserPlayVideoFinishedEventListener.class);
    private final UserService userService;
    private final UserIntegration userIntegration;

    public UserPlayVideoFinishedEventListener(UserService userService, UserIntegration userIntegration) {
        this.userService = userService;
        this.userIntegration = userIntegration;
    }

    @Subscribe
    public void consume(SdkGeneralEvent event) {
        DotMtEnum[] dotMtEnums;
        SdkEndpoint endpoint = event.getEndpoint();
        for (DotMtEnum dotMtEnum : dotMtEnums = event.getDotMtEnums()) {
            if (dotMtEnum != DotMtEnum._16008) continue;
            String positionId = endpoint.getPositionId();
            String uid = AdxEndpointHandle.getUid(this.userIntegration, endpoint);
            this.userService.plusPayVideoFinished(positionId, uid);
        }
    }
}

