/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners.sdk;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.listeners.SdkDotSupport;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.sdk.SdkViewEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SdkViewDotEventListener
extends SdkDotSupport
implements EventListener<SdkViewEvent> {
    private static final Logger log = LoggerFactory.getLogger(SdkViewDotEventListener.class);
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Resource
    private UserIntegration userIntegration;

    @Subscribe
    public void consume(SdkViewEvent event) {
        SdkEndpoint endpoint = event.getEndpoint();
        if (!StringHelper.isNewVersion((String)"2.4.3", (String)endpoint.getSdkVersion())) {
            return;
        }
        String positionId = endpoint.getPositionId();
        String devNo = AdxEndpointHandle.getUid(this.userIntegration, endpoint);
        String dmy = DateHelper.format((Date)new Date(), (String)"yyyyMMdd");
        String thirdSdkType = endpoint.getThirdSdkType();
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getSdk((String)positionId, (String)dmy, (String)devNo);
        this.counter.hincrementAndGet(keyGenerator, thirdSdkType, 86400);
    }
}

