/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners.task;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.Task;
import com.bxm.adxcounter.service.listeners.TaskDotSupport;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.task.TaskSucceedEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TaskSucceedEventListener
extends TaskDotSupport
implements EventListener<TaskSucceedEvent> {
    private static final Logger log = LoggerFactory.getLogger(TaskSucceedEventListener.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;

    @Subscribe
    public void consume(TaskSucceedEvent event) {
        TaskEndpoint endpoint = event.getEndpoint();
        String taskIdStr = endpoint.getTaskId();
        if (StringUtils.isEmpty((String)taskIdStr)) {
            log.warn("taskIdStr is empty\uff01appId={}", (Object)endpoint.getAppId());
            return;
        }
        Task task = (Task)this.fetcher.hfetch(AdxKeyGenerator.Task.getAllList(), taskIdStr, Task.class);
        if (task == null) {
            log.warn("\u4efb\u52a1\u4fe1\u606f\uff08{}\uff09\u4e3a\u7a7a\uff01", (Object)taskIdStr);
            return;
        }
        if (1 != task.getStatus()) {
            log.warn("\u4efb\u52a1\u4fe1\u606f\uff08{}\uff09\u4e0d\u662f\u5f00\u542f\u72b6\u6001\uff0c\u65e0\u9700\u7edf\u8ba1\uff01", (Object)taskIdStr);
            return;
        }
        Long taskId = Long.valueOf(taskIdStr);
        String dmy = DateHelper.format((Date)new Date(), (String)"yyyyMMdd");
        KeyGenerator taskKeyGenerator = AdxKeyGenerator.Task.getCounter((Long)taskId, (String)dmy);
        this.counter.hincrementAndGet(taskKeyGenerator, "SUCCEED_WAKES", 86400);
        super.consume(event.getDotMtEnums(), endpoint);
    }
}

