/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure.alions;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.mq.alions.AlionsProducer;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AlionsConfiguration.class, AlionsPropsConfiguration.class})
@ConditionalOnClass(value={com.aliyun.openservices.ons.api.Producer.class})
public class AlionsAutoConfiguration
extends AbstractSubscriberHandler {
    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private AlionsPropsConfiguration propsConfiguration;

    @Bean(initMethod="start", destroyMethod="close")
    public Producer alionsProducer() {
        Properties config = this.propsConfiguration.getConfig();
        if (null != config) {
            return new AlionsProducer(config);
        }
        return new AlionsProducer(this.configuration.getProducerId(), this.configuration.getAccessKey(), this.configuration.getSecretKey());
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        Properties config = this.propsConfiguration.getConfig();
        config.put("ConsumerId", consumerId);
        return new AlionsConsumer(config, messageListener);
    }
}

