/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.common.transfer;

import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import com.bxm.adxcounter.facade.model.TaskCounterDTO;
import com.bxm.adxcounter.service.common.transfer.AdxDecrypt;
import com.bxm.adxcounter.service.common.transfer.Dsp;
import com.bxm.adxcounter.service.common.transfer.SdkConvert;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigDecimal;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdxConvert {
    private static final Logger log = LoggerFactory.getLogger(AdxConvert.class);
    private final KeyGenerator KEY_DSP = () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSPS"});
    @Autowired
    private Fetcher fetcher;
    @Autowired
    private SdkConvert sdkConvert;
    private final double WIN_LI = 10.0;

    public void of(AdxEndpoint endpoint, AdxCounterDTO counter) {
        endpoint.of(counter);
        endpoint.setBxmBidId(counter.getBidid());
        endpoint.setPositionId(counter.getTagid());
        endpoint.setDspId(counter.getDspid());
        endpoint.setCreateId(counter.getCreateid());
        endpoint.setWinPrice(this.getAdxPrice(counter));
        endpoint.setStatus(counter.getStatus());
        endpoint.setActivityId(counter.getActid());
        endpoint.setSceneType(counter.getScene());
        this.sdkConvert.fillSdkInitInfo(endpoint, counter);
    }

    public void of(AdxEndpoint endpoint, TaskCounterDTO counter) {
        endpoint.of(counter);
        endpoint.setBxmBidId(counter.getBidid());
        endpoint.setPositionId(counter.getTagid());
        endpoint.setDspId(counter.getDspid());
        this.sdkConvert.fillSdkInitInfo(endpoint, counter);
    }

    private Double getAdxPrice(AdxCounterDTO counter) {
        if (StringUtils.isBlank((CharSequence)counter.getWin())) {
            return null;
        }
        String win = null;
        if (NumberUtils.isNumber((String)counter.getWin())) {
            win = counter.getWin();
        } else {
            Dsp dsp = (Dsp)this.fetcher.hfetch(this.KEY_DSP, counter.getDspid(), Dsp.class);
            if (null == dsp) {
                log.error("Not find DSP, dspId={}", (Object)counter.getDspid());
                return null;
            }
            try {
                win = AdxDecrypt.decrypt(counter.getWin(), dsp.getApiKey());
            }
            catch (Exception e) {
                log.error("decrypt price fail, win={}", (Object)counter.getWin());
                return null;
            }
        }
        return new BigDecimal(win).doubleValue() * 10.0;
    }
}

