/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.common.transfer;

import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adxcounter.facade.model.AbstractCounterDTO;
import com.bxm.adxcounter.facade.model.SdkCounterDTO;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.model.endpoint.AbstractEndpoint;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SdkConvert {
    private static final Logger log = LoggerFactory.getLogger(SdkConvert.class);
    @Autowired
    private UserIntegration userIntegration;

    public void of(SdkEndpoint endpoint, SdkCounterDTO counter) {
        endpoint.of(counter);
        endpoint.setSdkVersion(counter.getSdkv());
        endpoint.setPositionId(counter.getTagid());
        endpoint.setThirdSdkType(counter.getType());
        endpoint.setErrorCode(counter.getCode());
        endpoint.setThirdErrorCode(counter.getTcode());
        this.fillSdkInitInfo(endpoint, counter);
    }

    public void fillSdkInitInfo(AbstractEndpoint endpoint, AbstractCounterDTO counter) {
        SdkInitCache sdkInitCache = this.userIntegration.getSdkInit(DevRequest.builder().osStr(counter.getOs()).imei(counter.getImei()).anid(counter.getAnid()).idfa(counter.getIdfa()).build());
        if (null != sdkInitCache) {
            endpoint.setDeviceModel((String)StringUtils.defaultIfBlank((CharSequence)endpoint.getDeviceModel(), (CharSequence)sdkInitCache.getDevm()));
            endpoint.setDeviceBrand((String)StringUtils.defaultIfBlank((CharSequence)endpoint.getDeviceBrand(), (CharSequence)sdkInitCache.getDevb()));
            endpoint.setNetType((String)StringUtils.defaultIfBlank((CharSequence)endpoint.getNetType(), (CharSequence)sdkInitCache.getNet()));
        }
    }
}

