/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.facade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.adx.facade.constant.enums.AppPlatformTypeEnum;
import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.facade.rule.app.App;
import com.bxm.adxcounter.facade.constant.SdkMtEnum;
import com.bxm.adxcounter.facade.model.SdkCounterDTO;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import com.bxm.adxcounter.facade.service.SdkService;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.transfer.SdkConvert;
import com.bxm.adxcounter.service.model.dev.InstalledApp;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.service.SdkEndpointService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SdkServiceImpl
implements SdkService {
    private static final Logger log = LoggerFactory.getLogger(SdkServiceImpl.class);
    @Autowired
    private SdkEndpointService sdkEndpointService;
    @Autowired
    private SdkConvert sdkConvert;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Resource
    private UserIntegration userIntegration;

    @Override
    public ResponseEntity init(@RequestBody SdkEquipmentDTO sdk) {
        this.autoFillSdkEquipmentDTO(sdk);
        String devNo = this.userIntegration.getUid((SdkPublicDTO)sdk);
        if (StringUtils.isNotEmpty((CharSequence)devNo)) {
            this.cacheSdkInitInfo(devNo, sdk);
            if (StringUtils.isNotBlank((CharSequence)sdk.getAppl())) {
                ArrayList packageList = new ArrayList();
                List appList = (List)JSON.parseObject((String)sdk.getAppl(), (TypeReference)new TypeReference<ArrayList<InstalledApp>>(){}, (Feature[])new Feature[0]);
                if (CollectionUtils.isNotEmpty((Collection)appList)) {
                    appList.forEach(app -> packageList.add(app.getPackageName()));
                }
                KeyGenerator keyGenerator = AdxKeyGenerator.Device.getInitInstalledList(devNo);
                this.updater.update(keyGenerator, packageList, 86400);
            }
        }
        return this.sdkEndpointService.init(sdk);
    }

    private void autoFillSdkEquipmentDTO(@RequestBody SdkEquipmentDTO sdk) {
        if (null == sdk.getTimestamp()) {
            sdk.setTimestamp(System.currentTimeMillis());
        }
        if (StringUtils.isNotBlank((CharSequence)sdk.getAppid())) {
            DevOsEnum devOsEnum = DevOsEnum.of(sdk.getOs());
            KeyGenerator keyGenerator = AdxKeyGenerator.App.getInfoByCustom(sdk.getAppid(), AppPlatformTypeEnum.convert(sdk.getOs()).getId());
            App app = (App)this.fetcher.fetch(keyGenerator, App.class);
            if (null != app) {
                sdk.setAppid(app.getAppId());
            }
        }
    }

    private void cacheSdkInitInfo(String devNo, SdkEquipmentDTO sdk) {
        SdkInitCache sdkCache = new SdkInitCache();
        sdkCache.setMac(sdk.getMac());
        sdkCache.setOs(sdk.getOs());
        sdkCache.setOsv(sdk.getOsv());
        sdkCache.setImei(sdk.getImei());
        sdkCache.setImei_md5(sdk.getImei_md5());
        sdkCache.setAnid(sdk.getAnid());
        sdkCache.setAnid_md5(sdk.getAnid_md5());
        sdkCache.setOaid(sdk.getOaid());
        sdkCache.setIdfa(sdk.getIdfa());
        sdkCache.setIdfa_md5(sdk.getIdfa_md5());
        sdkCache.setDevid(sdk.getDevid());
        sdkCache.setDevb(sdk.getDevb());
        sdkCache.setDevm(sdk.getDevm());
        sdkCache.setDevt(sdk.getDevt());
        sdkCache.setDevsh(sdk.getDevsh());
        sdkCache.setDevsw(sdk.getDevsw());
        sdkCache.setMemory(sdk.getMemory());
        sdkCache.setStorage(sdk.getStorage());
        sdkCache.setCpum(sdk.getCpum());
        sdkCache.setIsp(sdk.getIsp());
        sdkCache.setNet(sdk.getNet());
        sdkCache.setLon(sdk.getLon());
        sdkCache.setLat(sdk.getLat());
        sdkCache.setSdkv(sdk.getSdkv());
        sdkCache.setPkn(sdk.getPkn());
        KeyGenerator keyGenerator = AdxKeyGenerator.Device.getInitInfo(devNo);
        this.updater.update(keyGenerator, (Object)sdkCache, 86400);
    }

    @Override
    public void extBind(@RequestBody SdkPublicDTO dto) {
        this.sdkEndpointService.extBind(dto);
    }

    @Override
    public ResponseEntity counter(@RequestBody SdkCounterDTO counter) {
        SdkMtEnum mtEnum = SdkMtEnum.of(counter.getMt());
        if (SdkMtEnum._OTHER == mtEnum) {
            return ResponseEntity.badRequest().body((Object)"mt\u4e0d\u5339\u914d");
        }
        SdkEndpoint endpoint = new SdkEndpoint();
        this.sdkConvert.of(endpoint, counter);
        return this.sdkEndpointService.post(mtEnum, endpoint);
    }
}

