/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.facade;

import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.TaskCounterDTO;
import com.bxm.adxcounter.facade.service.TaskCounterService;
import com.bxm.adxcounter.service.common.transfer.AdxConvert;
import com.bxm.adxcounter.service.common.transfer.TaskConvert;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.service.AdxEndpointService;
import com.bxm.adxcounter.service.service.TaskEndpointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskCounterServiceImpl
implements TaskCounterService {
    private static final Logger log = LoggerFactory.getLogger(TaskCounterServiceImpl.class);
    @Autowired
    private AdxEndpointService adxEndpointService;
    @Autowired
    private TaskEndpointService taskEndpointService;
    @Autowired
    private AdxConvert adxConvert;
    @Autowired
    private TaskConvert taskConvert;

    @Override
    public ResponseEntity counter(@RequestBody TaskCounterDTO counter) {
        AdxMtEnum mtEnum = AdxMtEnum.of(counter.getMt());
        if (AdxMtEnum._OTHER == mtEnum) {
            return ResponseEntity.badRequest().body((Object)"mt\u4e0d\u5339\u914d");
        }
        if (AdxMtEnum._202 == mtEnum) {
            this.dotAdx(counter, AdxMtEnum._105);
        } else if (AdxMtEnum._203 == mtEnum) {
            this.dotAdx(counter, AdxMtEnum._106);
        }
        TaskEndpoint endpoint = new TaskEndpoint();
        this.taskConvert.of(endpoint, counter);
        return this.taskEndpointService.post(mtEnum, endpoint);
    }

    private void dotAdx(TaskCounterDTO counter, AdxMtEnum mtEnum) {
        AdxEndpoint endpoint = new AdxEndpoint();
        this.adxConvert.of(endpoint, counter);
        this.adxEndpointService.post(mtEnum, endpoint);
    }
}

