/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners.adx;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.events.adx.AdxGeneralEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import org.springframework.stereotype.Service;

@Service
public class ShowStatisticsEventListener
implements EventListener<AdxGeneralEvent> {
    private final Counter counter;
    private final UserIntegration userIntegration;

    public ShowStatisticsEventListener(Counter counter, UserIntegration userIntegration) {
        this.counter = counter;
        this.userIntegration = userIntegration;
    }

    @Subscribe
    public void consume(AdxGeneralEvent event) {
        DotMtEnum[] dotMtEnums;
        AdxEndpoint endpoint = event.getEndpoint();
        for (DotMtEnum dotMtEnum : dotMtEnums = event.getDotMtEnums()) {
            if (dotMtEnum != DotMtEnum._15005) continue;
            this.handleWithPerDay(endpoint);
            this.handleWithUid(endpoint);
        }
    }

    private void handleWithPerDay(AdxEndpoint endpoint) {
        String positionId = endpoint.getPositionId();
        String dspId = endpoint.getDspId();
        KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"statistics", "adx", "show", DateHelper.getDate(), positionId});
        this.counter.hincrementAndGet(key, dspId);
    }

    private void handleWithUid(AdxEndpoint endpoint) {
        String positionId = endpoint.getPositionId();
        String dspId = endpoint.getDspId();
        String uid = AdxEndpointHandle.getUid(this.userIntegration, endpoint);
        KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"statistics", "adx", "show", DateHelper.getDate(), positionId, dspId, uid});
        this.counter.incrementAndGet(key, 86400);
    }
}

