/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners.sdk;

import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.adxcounter.service.model.events.sdk.SdkExtBindEvent;
import com.bxm.adxcounter.service.service.UserService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SdkExtBindingEventListener
implements EventListener<SdkExtBindEvent> {
    private static final Logger log = LoggerFactory.getLogger(SdkExtBindingEventListener.class);
    private final ApplicationGlobalConfig config;
    private final UserService userService;
    private UserIntegration userIntegration;

    public SdkExtBindingEventListener(ApplicationGlobalConfig config, UserService userService, UserIntegration userIntegration) {
        this.config = config;
        this.userService = userService;
        this.userIntegration = userIntegration;
    }

    @Subscribe
    public void consume(SdkExtBindEvent event) {
        SdkPublicDTO endpoint = event.getEndpoint();
        String appid = endpoint.getAppid();
        if (!this.config.getApp().getEnableExtBindingAppId().contains(appid)) {
            log.info("{} is not enable ext-binding.", (Object)appid);
            return;
        }
        Map<String, String> extForMap = endpoint.getExtForMap();
        if (MapUtils.isEmpty(extForMap)) {
            return;
        }
        String cuid = extForMap.get("cuid");
        String uid = this.userIntegration.getUid(endpoint);
        this.userService.setUserMapping(appid, uid, cuid);
    }
}

