/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.listeners.task;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adxcounter.service.listeners.TaskDotSupport;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.task.TaskAcquireEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TaskAcquireEventListener
extends TaskDotSupport
implements EventListener<TaskAcquireEvent> {
    private static final Logger log = LoggerFactory.getLogger(TaskAcquireEventListener.class);
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;

    @Subscribe
    public void consume(TaskAcquireEvent event) {
        TaskEndpoint endpoint = event.getEndpoint();
        String taskIdStr = endpoint.getTaskId();
        if (StringUtils.isEmpty((String)taskIdStr)) {
            log.warn("taskIdStr is empty\uff01appId={}", (Object)endpoint.getAppId());
            return;
        }
        Long taskId = Long.valueOf(taskIdStr);
        String dmy = DateHelper.format((Date)new Date(), (String)"yyyyMMdd");
        KeyGenerator taskKeyGenerator = AdxKeyGenerator.Task.getCounter(taskId, dmy);
        this.counter.hincrementAndGet(taskKeyGenerator, "ACQUIRES", 86400);
        super.consume(event.getDotMtEnums(), endpoint);
    }
}

