/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.model.endpoint;

import com.bxm.adxcounter.facade.model.AbstractCounterDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractEndpoint
implements Serializable {
    private static final long serialVersionUID = -4805979249918133754L;
    private String devUid;
    private Long timestamp;
    private String ip;
    private String ua;
    private String mac;
    private String os;
    private String imei;
    private String imeiMd5;
    private String androidId;
    private String androidIdMd5;
    private String oaid;
    private String idfa;
    private String idfaMd5;
    private String deviceBrand;
    private String deviceModel;
    private String netType;
    private String longitude;
    private String latitude;

    public void of(AbstractCounterDTO counter) {
        if (StringUtils.isBlank((CharSequence)counter.getT())) {
            this.setTimestamp(System.currentTimeMillis());
        } else {
            try {
                this.setTimestamp(new BigDecimal(counter.getT()).longValue());
            }
            catch (Exception e) {
                this.setTimestamp(System.currentTimeMillis());
            }
        }
        this.setIp(counter.getIp());
        this.setUa(counter.getUa());
        this.setMac(counter.getMac());
        this.setOs(counter.getOs());
        this.setImei(counter.getImei());
        this.setImeiMd5(counter.getImei_md5());
        this.setAndroidId(counter.getAnid());
        this.setAndroidIdMd5(counter.getAnid_md5());
        this.setOaid(counter.getOaid());
        this.setIdfa(counter.getIdfa());
        this.setIdfaMd5(counter.getIdfa_md5());
        this.setDeviceBrand(counter.getDevb());
        this.setDeviceModel(counter.getDevm());
        this.setNetType(counter.getNet());
        this.setLongitude(counter.getLon());
        this.setLatitude(counter.getLat());
    }

    public String getDevUid() {
        return this.devUid;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUa() {
        return this.ua;
    }

    public String getMac() {
        return this.mac;
    }

    public String getOs() {
        return this.os;
    }

    public String getImei() {
        return this.imei;
    }

    public String getImeiMd5() {
        return this.imeiMd5;
    }

    public String getAndroidId() {
        return this.androidId;
    }

    public String getAndroidIdMd5() {
        return this.androidIdMd5;
    }

    public String getOaid() {
        return this.oaid;
    }

    public String getIdfa() {
        return this.idfa;
    }

    public String getIdfaMd5() {
        return this.idfaMd5;
    }

    public String getDeviceBrand() {
        return this.deviceBrand;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getNetType() {
        return this.netType;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setDevUid(String devUid) {
        this.devUid = devUid;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public void setAndroidIdMd5(String androidIdMd5) {
        this.androidIdMd5 = androidIdMd5;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public void setDeviceBrand(String deviceBrand) {
        this.deviceBrand = deviceBrand;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setNetType(String netType) {
        this.netType = netType;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEndpoint)) {
            return false;
        }
        AbstractEndpoint other = (AbstractEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$devUid = this.getDevUid();
        String other$devUid = other.getDevUid();
        if (this$devUid == null ? other$devUid != null : !this$devUid.equals(other$devUid)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$ua = this.getUa();
        String other$ua = other.getUa();
        if (this$ua == null ? other$ua != null : !this$ua.equals(other$ua)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        String this$imei = this.getImei();
        String other$imei = other.getImei();
        if (this$imei == null ? other$imei != null : !this$imei.equals(other$imei)) {
            return false;
        }
        String this$imeiMd5 = this.getImeiMd5();
        String other$imeiMd5 = other.getImeiMd5();
        if (this$imeiMd5 == null ? other$imeiMd5 != null : !this$imeiMd5.equals(other$imeiMd5)) {
            return false;
        }
        String this$androidId = this.getAndroidId();
        String other$androidId = other.getAndroidId();
        if (this$androidId == null ? other$androidId != null : !this$androidId.equals(other$androidId)) {
            return false;
        }
        String this$androidIdMd5 = this.getAndroidIdMd5();
        String other$androidIdMd5 = other.getAndroidIdMd5();
        if (this$androidIdMd5 == null ? other$androidIdMd5 != null : !this$androidIdMd5.equals(other$androidIdMd5)) {
            return false;
        }
        String this$oaid = this.getOaid();
        String other$oaid = other.getOaid();
        if (this$oaid == null ? other$oaid != null : !this$oaid.equals(other$oaid)) {
            return false;
        }
        String this$idfa = this.getIdfa();
        String other$idfa = other.getIdfa();
        if (this$idfa == null ? other$idfa != null : !this$idfa.equals(other$idfa)) {
            return false;
        }
        String this$idfaMd5 = this.getIdfaMd5();
        String other$idfaMd5 = other.getIdfaMd5();
        if (this$idfaMd5 == null ? other$idfaMd5 != null : !this$idfaMd5.equals(other$idfaMd5)) {
            return false;
        }
        String this$deviceBrand = this.getDeviceBrand();
        String other$deviceBrand = other.getDeviceBrand();
        if (this$deviceBrand == null ? other$deviceBrand != null : !this$deviceBrand.equals(other$deviceBrand)) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        if (this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel)) {
            return false;
        }
        String this$netType = this.getNetType();
        String other$netType = other.getNetType();
        if (this$netType == null ? other$netType != null : !this$netType.equals(other$netType)) {
            return false;
        }
        String this$longitude = this.getLongitude();
        String other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) {
            return false;
        }
        String this$latitude = this.getLatitude();
        String other$latitude = other.getLatitude();
        return !(this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $devUid = this.getDevUid();
        result = result * 59 + ($devUid == null ? 43 : $devUid.hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $ua = this.getUa();
        result = result * 59 + ($ua == null ? 43 : $ua.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        String $imei = this.getImei();
        result = result * 59 + ($imei == null ? 43 : $imei.hashCode());
        String $imeiMd5 = this.getImeiMd5();
        result = result * 59 + ($imeiMd5 == null ? 43 : $imeiMd5.hashCode());
        String $androidId = this.getAndroidId();
        result = result * 59 + ($androidId == null ? 43 : $androidId.hashCode());
        String $androidIdMd5 = this.getAndroidIdMd5();
        result = result * 59 + ($androidIdMd5 == null ? 43 : $androidIdMd5.hashCode());
        String $oaid = this.getOaid();
        result = result * 59 + ($oaid == null ? 43 : $oaid.hashCode());
        String $idfa = this.getIdfa();
        result = result * 59 + ($idfa == null ? 43 : $idfa.hashCode());
        String $idfaMd5 = this.getIdfaMd5();
        result = result * 59 + ($idfaMd5 == null ? 43 : $idfaMd5.hashCode());
        String $deviceBrand = this.getDeviceBrand();
        result = result * 59 + ($deviceBrand == null ? 43 : $deviceBrand.hashCode());
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        String $netType = this.getNetType();
        result = result * 59 + ($netType == null ? 43 : $netType.hashCode());
        String $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : $longitude.hashCode());
        String $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : $latitude.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractEndpoint(devUid=" + this.getDevUid() + ", timestamp=" + this.getTimestamp() + ", ip=" + this.getIp() + ", ua=" + this.getUa() + ", mac=" + this.getMac() + ", os=" + this.getOs() + ", imei=" + this.getImei() + ", imeiMd5=" + this.getImeiMd5() + ", androidId=" + this.getAndroidId() + ", androidIdMd5=" + this.getAndroidIdMd5() + ", oaid=" + this.getOaid() + ", idfa=" + this.getIdfa() + ", idfaMd5=" + this.getIdfaMd5() + ", deviceBrand=" + this.getDeviceBrand() + ", deviceModel=" + this.getDeviceModel() + ", netType=" + this.getNetType() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ")";
    }
}

