/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.service.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.adxcounter.service.common.autoconfigure.config.GetuiConfig;
import com.bxm.adxcounter.service.service.GetuiService;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.http.HttpClientUtils;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetuiServiceImpl
implements GetuiService,
MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(GetuiServiceImpl.class);
    private final ApplicationGlobalConfig config;
    private final Fetcher fetcher;
    private CloseableHttpClient httpClient;
    private MeterRegistry registry;
    private Timer timer;
    private Map<String, Counter> failOnType = Maps.newConcurrentMap();

    public GetuiServiceImpl(ApplicationGlobalConfig config, Fetcher fetcher) {
        this.config = config;
        this.fetcher = fetcher;
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultMaxPerRoute(416);
        connectionManager.setMaxTotal(5000);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50).setConnectTimeout(30).setConnectionRequestTimeout(10).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
        this.timer = Timer.builder((String)"getui.requests").register(registry);
    }

    @Override
    public List<String> fetchTags(SdkEquipmentDTO endpoint) {
        GetuiRequest request = this.ofEndpoint(endpoint);
        return this.fetcher.fetchToList(new TargetFactory().keyGenerator(() -> KeyBuilder.build((Object[])new Object[]{"tmp", "getui", "tags", DigestUtils.md5Hex((String)request.toString())})).skipNativeCache(true).cls(String.class).expireTimeInSecond(86400).selector(5).listDataExtractor(() -> this.fetchTags(request)).build());
    }

    private GetuiRequest ofEndpoint(SdkEquipmentDTO endpoint) {
        String empty = "";
        return GetuiRequest.builder().imeiMD5(StringUtils.isNotBlank((String)endpoint.getImei_md5()) ? endpoint.getImei_md5() : (StringUtils.isNotBlank((String)endpoint.getImei()) ? DigestUtils.md5Hex((String)endpoint.getImei()) : empty)).macMD5(StringUtils.isNotBlank((String)endpoint.getMac()) ? DigestUtils.md5Hex((String)endpoint.getMac()) : empty).imsiMD5(empty).idfa(endpoint.getIdfa()).idfaMD5(StringUtils.isNotBlank((String)endpoint.getIdfa_md5()) ? endpoint.getIdfa_md5() : (StringUtils.isNotBlank((String)endpoint.getIdfa()) ? DigestUtils.md5Hex((String)endpoint.getIdfa()) : empty)).oaid(endpoint.getOaid()).oaidMD5(StringUtils.isNotBlank((String)endpoint.getOaid()) ? DigestUtils.md5Hex((String)endpoint.getOaid()) : empty).androidId(endpoint.getAnid()).androidIdMD5(StringUtils.isNotBlank((String)endpoint.getAnid_md5()) ? endpoint.getAnid_md5() : (StringUtils.isNotBlank((String)endpoint.getAnid()) ? DigestUtils.md5Hex((String)endpoint.getAnid()) : empty)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> fetchTags(GetuiRequest request) {
        long start = System.nanoTime();
        String url = this.config.getGetui().getFetchTagUrl();
        HashMap headers = Maps.newHashMap();
        headers.put("Authorization", "Bearer " + this.getAccessCode());
        headers.put("Accept", "application/vnd.dmp.v1+json");
        try {
            String body = this.postRequestBody(url, request, headers);
            if (StringUtils.isNotBlank((String)body)) {
                GetuiResponse response = (GetuiResponse)JsonHelper.convert((String)body, GetuiResponse.class);
                List<String> list = response.getData();
                return list;
            }
        }
        catch (Exception e) {
            String message = e.getClass().getSimpleName();
            Counter counter = this.failOnType.get(message);
            if (Objects.isNull(counter)) {
                counter = Counter.builder((String)"getui.fail").tags(new String[]{"type", message}).register(this.registry);
                this.failOnType.put(message, counter);
            }
            counter.increment();
        }
        finally {
            if (Objects.nonNull(this.timer)) {
                this.timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
        return Lists.newArrayList();
    }

    private String getAccessCode() {
        return (String)this.fetcher.fetch(new TargetFactory().keyGenerator(() -> KeyBuilder.build((Object[])new Object[]{"tmp", "getui", "access_token"})).skipNativeCache(false).cls(String.class).expireTimeInSecond(7000).selector(5).dataExtractor(() -> {
            GetuiConfig getui = this.config.getGetui();
            String userCode = getui.getUserCode();
            String authCode = getui.getAuthCode();
            String authUrl = getui.getAuthUrl();
            String timestamp = String.valueOf(System.currentTimeMillis());
            HashMap params = Maps.newHashMap();
            params.put("user_code", userCode);
            params.put("sign1", DigestUtils.md5Hex((String)(userCode + DigestUtils.md5Hex((String)timestamp))));
            params.put("sign2", DigestUtils.md5Hex((String)(userCode + authCode + DigestUtils.md5Hex((String)timestamp))));
            params.put("timestamp", timestamp);
            HashMap headers = Maps.newHashMap();
            try {
                String body = this.get(authUrl, params, headers);
                if (StringUtils.isNotBlank((String)body)) {
                    GetuiAccessResponse response = (GetuiAccessResponse)JsonHelper.convert((String)body, GetuiAccessResponse.class);
                    return response.getAccessToken();
                }
            }
            catch (Exception e) {
                log.warn("getAccessCode: ", (Throwable)e);
            }
            return null;
        }).build());
    }

    private String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(OkHttpUtils.appendParams((String)url, params));
        HttpClientUtils.setHeader((HttpRequestBase)httpGet, headers);
        return this.doRequest((HttpRequestBase)httpGet, headers);
    }

    private String postRequestBody(String url, Object o, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtils.setRequestBody((HttpPost)httpPost, (Object)o);
        return this.doRequest((HttpRequestBase)httpPost, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRequest(HttpRequestBase httpReq, Map<String, String> headers) throws IOException {
        try (CloseableHttpResponse httpResp = null;){
            HttpClientUtils.setHeader((HttpRequestBase)httpReq, headers);
            httpResp = this.httpClient.execute((HttpUriRequest)httpReq);
            String string = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            return string;
        }
    }

    private static class GetuiAccessResponse
    implements Serializable {
        private static final long serialVersionUID = -3405031987864169602L;
        private String code;
        @JSONField(name="access_token")
        private String accessToken;
        @JSONField(name="expires_in")
        private Long expiresIn;

        public String getCode() {
            return this.code;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetuiAccessResponse)) {
                return false;
            }
            GetuiAccessResponse other = (GetuiAccessResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            Long this$expiresIn = this.getExpiresIn();
            Long other$expiresIn = other.getExpiresIn();
            return !(this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetuiAccessResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            Long $expiresIn = this.getExpiresIn();
            result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
            return result;
        }

        public String toString() {
            return "GetuiServiceImpl.GetuiAccessResponse(code=" + this.getCode() + ", accessToken=" + this.getAccessToken() + ", expiresIn=" + this.getExpiresIn() + ")";
        }
    }

    private static class GetuiResponse
    implements Serializable {
        private static final long serialVersionUID = 8092303601506991826L;
        private String code;
        private List<String> data;

        public String getCode() {
            return this.code;
        }

        public List<String> getData() {
            return this.data;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetuiResponse)) {
                return false;
            }
            GetuiResponse other = (GetuiResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetuiResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "GetuiServiceImpl.GetuiResponse(code=" + this.getCode() + ", data=" + this.getData() + ")";
        }
    }

    private static class GetuiRequest
    implements Serializable {
        private static final long serialVersionUID = -4643729044689196299L;
        private String imeiMD5;
        private String macMD5;
        private String imsiMD5;
        private String mb;
        private String idfa;
        private String idfaMD5;
        private String oaid;
        private String oaidMD5;
        private String androidId;
        private String androidIdMD5;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }

        public static GetuiRequestBuilder builder() {
            return new GetuiRequestBuilder();
        }

        public String getImeiMD5() {
            return this.imeiMD5;
        }

        public String getMacMD5() {
            return this.macMD5;
        }

        public String getImsiMD5() {
            return this.imsiMD5;
        }

        public String getMb() {
            return this.mb;
        }

        public String getIdfa() {
            return this.idfa;
        }

        public String getIdfaMD5() {
            return this.idfaMD5;
        }

        public String getOaid() {
            return this.oaid;
        }

        public String getOaidMD5() {
            return this.oaidMD5;
        }

        public String getAndroidId() {
            return this.androidId;
        }

        public String getAndroidIdMD5() {
            return this.androidIdMD5;
        }

        public void setImeiMD5(String imeiMD5) {
            this.imeiMD5 = imeiMD5;
        }

        public void setMacMD5(String macMD5) {
            this.macMD5 = macMD5;
        }

        public void setImsiMD5(String imsiMD5) {
            this.imsiMD5 = imsiMD5;
        }

        public void setMb(String mb) {
            this.mb = mb;
        }

        public void setIdfa(String idfa) {
            this.idfa = idfa;
        }

        public void setIdfaMD5(String idfaMD5) {
            this.idfaMD5 = idfaMD5;
        }

        public void setOaid(String oaid) {
            this.oaid = oaid;
        }

        public void setOaidMD5(String oaidMD5) {
            this.oaidMD5 = oaidMD5;
        }

        public void setAndroidId(String androidId) {
            this.androidId = androidId;
        }

        public void setAndroidIdMD5(String androidIdMD5) {
            this.androidIdMD5 = androidIdMD5;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetuiRequest)) {
                return false;
            }
            GetuiRequest other = (GetuiRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$imeiMD5 = this.getImeiMD5();
            String other$imeiMD5 = other.getImeiMD5();
            if (this$imeiMD5 == null ? other$imeiMD5 != null : !this$imeiMD5.equals(other$imeiMD5)) {
                return false;
            }
            String this$macMD5 = this.getMacMD5();
            String other$macMD5 = other.getMacMD5();
            if (this$macMD5 == null ? other$macMD5 != null : !this$macMD5.equals(other$macMD5)) {
                return false;
            }
            String this$imsiMD5 = this.getImsiMD5();
            String other$imsiMD5 = other.getImsiMD5();
            if (this$imsiMD5 == null ? other$imsiMD5 != null : !this$imsiMD5.equals(other$imsiMD5)) {
                return false;
            }
            String this$mb = this.getMb();
            String other$mb = other.getMb();
            if (this$mb == null ? other$mb != null : !this$mb.equals(other$mb)) {
                return false;
            }
            String this$idfa = this.getIdfa();
            String other$idfa = other.getIdfa();
            if (this$idfa == null ? other$idfa != null : !this$idfa.equals(other$idfa)) {
                return false;
            }
            String this$idfaMD5 = this.getIdfaMD5();
            String other$idfaMD5 = other.getIdfaMD5();
            if (this$idfaMD5 == null ? other$idfaMD5 != null : !this$idfaMD5.equals(other$idfaMD5)) {
                return false;
            }
            String this$oaid = this.getOaid();
            String other$oaid = other.getOaid();
            if (this$oaid == null ? other$oaid != null : !this$oaid.equals(other$oaid)) {
                return false;
            }
            String this$oaidMD5 = this.getOaidMD5();
            String other$oaidMD5 = other.getOaidMD5();
            if (this$oaidMD5 == null ? other$oaidMD5 != null : !this$oaidMD5.equals(other$oaidMD5)) {
                return false;
            }
            String this$androidId = this.getAndroidId();
            String other$androidId = other.getAndroidId();
            if (this$androidId == null ? other$androidId != null : !this$androidId.equals(other$androidId)) {
                return false;
            }
            String this$androidIdMD5 = this.getAndroidIdMD5();
            String other$androidIdMD5 = other.getAndroidIdMD5();
            return !(this$androidIdMD5 == null ? other$androidIdMD5 != null : !this$androidIdMD5.equals(other$androidIdMD5));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetuiRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $imeiMD5 = this.getImeiMD5();
            result = result * 59 + ($imeiMD5 == null ? 43 : $imeiMD5.hashCode());
            String $macMD5 = this.getMacMD5();
            result = result * 59 + ($macMD5 == null ? 43 : $macMD5.hashCode());
            String $imsiMD5 = this.getImsiMD5();
            result = result * 59 + ($imsiMD5 == null ? 43 : $imsiMD5.hashCode());
            String $mb = this.getMb();
            result = result * 59 + ($mb == null ? 43 : $mb.hashCode());
            String $idfa = this.getIdfa();
            result = result * 59 + ($idfa == null ? 43 : $idfa.hashCode());
            String $idfaMD5 = this.getIdfaMD5();
            result = result * 59 + ($idfaMD5 == null ? 43 : $idfaMD5.hashCode());
            String $oaid = this.getOaid();
            result = result * 59 + ($oaid == null ? 43 : $oaid.hashCode());
            String $oaidMD5 = this.getOaidMD5();
            result = result * 59 + ($oaidMD5 == null ? 43 : $oaidMD5.hashCode());
            String $androidId = this.getAndroidId();
            result = result * 59 + ($androidId == null ? 43 : $androidId.hashCode());
            String $androidIdMD5 = this.getAndroidIdMD5();
            result = result * 59 + ($androidIdMD5 == null ? 43 : $androidIdMD5.hashCode());
            return result;
        }

        public GetuiRequest(String imeiMD5, String macMD5, String imsiMD5, String mb, String idfa, String idfaMD5, String oaid, String oaidMD5, String androidId, String androidIdMD5) {
            this.imeiMD5 = imeiMD5;
            this.macMD5 = macMD5;
            this.imsiMD5 = imsiMD5;
            this.mb = mb;
            this.idfa = idfa;
            this.idfaMD5 = idfaMD5;
            this.oaid = oaid;
            this.oaidMD5 = oaidMD5;
            this.androidId = androidId;
            this.androidIdMD5 = androidIdMD5;
        }

        public static class GetuiRequestBuilder {
            private String imeiMD5;
            private String macMD5;
            private String imsiMD5;
            private String mb;
            private String idfa;
            private String idfaMD5;
            private String oaid;
            private String oaidMD5;
            private String androidId;
            private String androidIdMD5;

            GetuiRequestBuilder() {
            }

            public GetuiRequestBuilder imeiMD5(String imeiMD5) {
                this.imeiMD5 = imeiMD5;
                return this;
            }

            public GetuiRequestBuilder macMD5(String macMD5) {
                this.macMD5 = macMD5;
                return this;
            }

            public GetuiRequestBuilder imsiMD5(String imsiMD5) {
                this.imsiMD5 = imsiMD5;
                return this;
            }

            public GetuiRequestBuilder mb(String mb) {
                this.mb = mb;
                return this;
            }

            public GetuiRequestBuilder idfa(String idfa) {
                this.idfa = idfa;
                return this;
            }

            public GetuiRequestBuilder idfaMD5(String idfaMD5) {
                this.idfaMD5 = idfaMD5;
                return this;
            }

            public GetuiRequestBuilder oaid(String oaid) {
                this.oaid = oaid;
                return this;
            }

            public GetuiRequestBuilder oaidMD5(String oaidMD5) {
                this.oaidMD5 = oaidMD5;
                return this;
            }

            public GetuiRequestBuilder androidId(String androidId) {
                this.androidId = androidId;
                return this;
            }

            public GetuiRequestBuilder androidIdMD5(String androidIdMD5) {
                this.androidIdMD5 = androidIdMD5;
                return this;
            }

            public GetuiRequest build() {
                return new GetuiRequest(this.imeiMD5, this.macMD5, this.imsiMD5, this.mb, this.idfa, this.idfaMD5, this.oaid, this.oaidMD5, this.androidId, this.androidIdMD5);
            }

            public String toString() {
                return "GetuiServiceImpl.GetuiRequest.GetuiRequestBuilder(imeiMD5=" + this.imeiMD5 + ", macMD5=" + this.macMD5 + ", imsiMD5=" + this.imsiMD5 + ", mb=" + this.mb + ", idfa=" + this.idfa + ", idfaMD5=" + this.idfaMD5 + ", oaid=" + this.oaid + ", oaidMD5=" + this.oaidMD5 + ", androidId=" + this.androidId + ", androidIdMD5=" + this.androidIdMD5 + ")";
            }
        }
    }
}

