/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.service.service.impl;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.position.Position;
import com.bxm.adxcounter.facade.model.UserData;
import com.bxm.adxcounter.service.service.UserService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final int EXPIRE_TIME = 604800;
    private final Counter counter;
    private final Updater updater;
    private final Fetcher fetcher;

    public UserServiceImpl(Counter counter, Updater updater, Fetcher fetcher) {
        this.counter = counter;
        this.updater = updater;
        this.fetcher = fetcher;
    }

    @Override
    public void plusPayVideoFinished(String positionId, String uid) {
        Position position = this.getPosition(positionId);
        if (null == position) {
            log.info("Cannot found position by {}", (Object)positionId);
            return;
        }
        String appId = position.getAppId();
        String cuid = this.getCuid(appId, uid);
        if (StringUtils.isBlank((CharSequence)cuid)) {
            return;
        }
        this.counter.hincrementAndGet(UserServiceImpl.getPayVideoFinishedKeyGenerator(appId), cuid, 604800);
    }

    @Override
    public long getPayVideoFinishedByAppId(String appId, String cuid, String date) {
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)cuid)) {
            return 0L;
        }
        KeyGenerator kg = UserServiceImpl.getPayVideoFinishedKeyGenerator(date, appId);
        return this.counter.hget(kg, cuid);
    }

    @Override
    public List<UserData> getPayVideoFinishedByAppId(String appId, String[] cuids, String date) {
        if (ArrayUtils.isEmpty((Object[])cuids) || cuids.length > 999) {
            throw new IllegalArgumentException("cuids");
        }
        Object original = this.counter.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            return Collections.emptyList();
        }
        JedisPool jedisPool = (JedisPool)original;
        try (Jedis jedis = jedisPool.getResource();){
            HashMap result = Maps.newHashMap();
            Pipeline pipelined = jedis.pipelined();
            for (String cuid : cuids) {
                KeyGenerator k = UserServiceImpl.getPayVideoFinishedKeyGenerator(date, appId);
                result.put(cuid, pipelined.hget(k.generateKey(), cuid));
            }
            pipelined.syncAndReturnAll();
            if (MapUtils.isNotEmpty((Map)result)) {
                ArrayList rs = Lists.newArrayListWithCapacity((int)result.size());
                for (Map.Entry entry : result.entrySet()) {
                    String cuid;
                    cuid = (String)entry.getKey();
                    Response redisRes = (Response)entry.getValue();
                    long times = NumberUtils.toLong((String)((String)redisRes.get()));
                    if (times <= 0L) continue;
                    rs.add(UserData.builder().cuid(cuid).finishedPlayVideoTimes(times).build());
                }
                ArrayList arrayList = rs;
                return arrayList;
            }
        }
        return null;
    }

    @Override
    public void setUserMapping(String appId, String uid, String cuid) {
        this.updater.hupdateWithSelector(UserServiceImpl.getUserMappingKeyGenerator(appId), uid, (Object)cuid, 1);
    }

    private String getCuid(String appId, String uid) {
        return (String)this.fetcher.hfetchWithSelector(UserServiceImpl.getUserMappingKeyGenerator(appId), uid, String.class, 1);
    }

    private Position getPosition(String positionId) {
        return (Position)this.fetcher.fetch(AdxKeyGenerator.Position.getInfo(positionId), Position.class);
    }

    private static KeyGenerator getPayVideoFinishedKeyGenerator(String appId) {
        return UserServiceImpl.getPayVideoFinishedKeyGenerator(DateHelper.getDate(), appId);
    }

    private static KeyGenerator getPayVideoFinishedKeyGenerator(String date, String appId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "COUNTER", "FINISHED_PLAY_VIDEO", date, appId});
    }

    private static KeyGenerator getUserMappingKeyGenerator(String appid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "USERMAPPING", appid});
    }
}

