#!/bin/bash

if [ ! -f ~/run/adxcounter-service.pid ]; then
  echo "Server [adxcounter-service] doest not started!"
  exit
fi

pid=`cat ~/run/adxcounter-service.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adxcounter-service.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adxcounter-service] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adxcounter-service] cannot stop, Please check pid file 'adxcounter-service.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adxcounter-service] has been stoped!"
fi

rm -f ~/run/adxcounter-service.pid