package com.bxm.adxcounter.service;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

import com.bxm.adxcounter.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import com.bxm.warcar.integration.autoconfigure.dc.dot.DotProperties;

/**
 * 主程序<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 11:18
 */
@SpringBootApplication
@EnableConfigurationProperties({DotProperties.class, ApplicationGlobalConfig.class})
@ComponentScan(basePackages = {"com.bxm.adxcounter"})
@EnableFeignClients({"com.bxm.mccms.facade.service","com.bxm.adx.facade.service","com.bxm.user.facade.service"})
public class AdxCounterServiceApplication {

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(AdxCounterServiceApplication.class);
        application.addListeners(new SpringBootEnvironmentListener());
        application.run(args);
    }
}
