package com.bxm.adxcounter.service.common.handle;

import com.bxm.adxcounter.integration.user.UserIntegration;
import com.bxm.adxcounter.service.model.endpoint.AbstractEndpoint;
import com.bxm.user.facade.DevRequest;

/**
 * 处理辅助类<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/31 20:48
 */
public class AdxEndpointHandle {

    /**
     * 获取设备号
     * @param endpoint
     * @return
     */
    public static String getUid(UserIntegration userIntegration, AbstractEndpoint endpoint){
        return userIntegration.getUid(DevRequest.builder()
                .osStr(endpoint.getOs())
                .imei(endpoint.getImei())
                .imeiMd5(endpoint.getImeiMd5())
                .anid(endpoint.getAndroidId())
                .anidMd5(endpoint.getAndroidIdMd5())
                .oaid(endpoint.getOaid())
                .idfa(endpoint.getIdfa())
                .idfaMd5(endpoint.getIdfaMd5())
                .build());
    }
}
