package com.bxm.adxcounter.service.common.transfer;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import com.bxm.adxcounter.facade.model.AbstractCounterDTO;
import com.bxm.adxcounter.facade.model.SdkCounterDTO;
import com.bxm.adxcounter.integration.user.UserIntegration;
import com.bxm.adxcounter.service.model.endpoint.AbstractEndpoint;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.SdkInitCache;

import lombok.extern.slf4j.Slf4j;

/**
 * 转换器-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 21:16
 */
@Slf4j
@Configuration
public class SdkConvert {

    @Autowired
    private UserIntegration userIntegration;
    
    /**
     * 参数转换<br/>
     * SDK<br/>
     *
     * @param  endpoint
     * @param  counter
     */
    public void of(SdkEndpoint endpoint, SdkCounterDTO counter){
        endpoint.of(counter);
        
        endpoint.setSdkVersion(counter.getSdkv());
        endpoint.setPositionId(counter.getTagid());
        endpoint.setThirdSdkType(counter.getType());
        endpoint.setErrorCode(counter.getCode());
        endpoint.setThirdErrorCode(counter.getTcode());

        //填充SDK初始化参数
        this.fillSdkInitInfo(endpoint, counter);
    }


    /**
     * 填充SDK初始化参数<br/>
     *
     * @param endpoint
     * @param counter
     */
    public void fillSdkInitInfo(AbstractEndpoint endpoint, AbstractCounterDTO counter) {
        //获取初始化参数
        SdkInitCache sdkInitCache = userIntegration.getSdkInit(DevRequest.builder()
                .osStr(counter.getOs())
                .imei(counter.getImei())
                .imeiMd5(counter.getImei_md5())
                .anid(counter.getAnid())
                .anidMd5(counter.getAnid_md5())
                .oaid(counter.getOaid())
                .idfa(counter.getIdfa())
                .idfaMd5(counter.getIdfa_md5())
                .build());
        if(null != sdkInitCache){
            endpoint.setDeviceModel(StringUtils.defaultIfBlank(endpoint.getDeviceModel(),
                    sdkInitCache.getDevm()));
            endpoint.setDeviceBrand(StringUtils.defaultIfBlank(endpoint.getDeviceBrand(),
                    sdkInitCache.getDevb()));
            endpoint.setNetType(StringUtils.defaultIfBlank(endpoint.getNetType(),
                    sdkInitCache.getNet()));
        }
    }
}
