package com.bxm.adxcounter.service.facade;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import com.bxm.adxcounter.facade.service.AdxCounterService;
import com.bxm.adxcounter.service.common.transfer.AdxConvert;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.service.AdxEndpointService;

import lombok.extern.slf4j.Slf4j;


@RestController
@Slf4j
public class AdxCounterServiceImpl implements AdxCounterService {
    
    @Autowired
    private AdxEndpointService adxEndpointService;
    @Autowired
    private AdxConvert adxConvert;

    @Override
    public ResponseEntity counter(@RequestBody AdxCounterDTO counter) {
        AdxMtEnum mtEnum = AdxMtEnum.of(counter.getMt());
        if(AdxMtEnum._OTHER == mtEnum){
            return ResponseEntity.badRequest().body("mt不匹配");
        }
        AdxEndpoint endpoint = new AdxEndpoint();
        adxConvert.of(endpoint, counter);
        return adxEndpointService.post(mtEnum, endpoint);
    }
}
