package com.bxm.adxcounter.service.facade;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.TaskCounterDTO;
import com.bxm.adxcounter.facade.service.TaskCounterService;
import com.bxm.adxcounter.service.common.transfer.AdxConvert;
import com.bxm.adxcounter.service.common.transfer.TaskConvert;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.service.AdxEndpointService;
import com.bxm.adxcounter.service.service.TaskEndpointService;

import lombok.extern.slf4j.Slf4j;

@RestController
@Slf4j
public class TaskCounterServiceImpl implements TaskCounterService {

    @Autowired
    private AdxEndpointService adxEndpointService;
    @Autowired
    private TaskEndpointService taskEndpointService;
    @Autowired
    private AdxConvert adxConvert;
    @Autowired
    private TaskConvert taskConvert;
    
    @Override
    public ResponseEntity counter(@RequestBody TaskCounterDTO counter) {
        AdxMtEnum mtEnum = AdxMtEnum.of(counter.getMt());
        if(AdxMtEnum._OTHER == mtEnum){
            return ResponseEntity.badRequest().body("mt不匹配");
        }
        if(AdxMtEnum._202 == mtEnum){
            dotAdx(counter, AdxMtEnum._105);
        }else if(AdxMtEnum._203 == mtEnum){
            dotAdx(counter, AdxMtEnum._106);
        }
        TaskEndpoint endpoint = new TaskEndpoint();
        taskConvert.of(endpoint, counter);
        return taskEndpointService.post(mtEnum, endpoint);
    }

    /**
     * adx埋点
     */
    private void dotAdx(TaskCounterDTO counter, AdxMtEnum mtEnum) {
        AdxEndpoint endpoint = new AdxEndpoint();
        adxConvert.of(endpoint, counter);
        adxEndpointService.post(mtEnum, endpoint);
    }
}
