package com.bxm.adxcounter.service.listeners;

import javax.annotation.Resource;

import java.util.HashMap;
import java.util.Map;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.utils.JsonHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 埋点超类-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 15:53
 */
@Slf4j
public class AdxDotSupport {

    @Resource
    private AsyncDot asyncDot;

    /**
     * 埋点<br/>
     */
    public void consume(DotMtEnum[] dotMtEnums, AdxEndpoint endpoint) {
        if(dotMtEnums.length > 1){
            for (DotMtEnum dotMtEnum: dotMtEnums) {
                asyncDotGet(dotMtEnum, endpoint);
            }
        }else{
            asyncDotGet(dotMtEnums[0], endpoint);
        }
    }

    private void asyncDotGet(DotMtEnum dotMtEnum, AdxEndpoint endpoint) {
        if (dotMtEnum == DotMtEnum._OTHER) {
            // unknown model type, so ignore.
            return;
        }

        Map<String, Object> parameter = new HashMap<>();
        parameter.put("bidid", endpoint.getBxmBidId());//竞价id
        parameter.put("tagid", endpoint.getPositionId());//广告位id
        parameter.put("t", endpoint.getTimestamp());//请求时间戳
        parameter.put("mt", dotMtEnum.getDotMt());//数据中心埋点值
        parameter.put("imei", endpoint.getImei());//imei
        parameter.put("imei_md5", endpoint.getImeiMd5());//imei_md5
        parameter.put("anid", endpoint.getAndroidId());//android id
        parameter.put("anid_md5", endpoint.getAndroidIdMd5());//android id md5
        parameter.put("oaid", endpoint.getOaid());//安全联盟定义的用户唯一标识OAID
        parameter.put("idfa", endpoint.getIdfa());//idfa
        parameter.put("idfa_md5", endpoint.getIdfaMd5());//idfa_md5
        parameter.put("ip", endpoint.getIp());//用户IP
        parameter.put("ua", endpoint.getUa());//User-Agent
        parameter.put("os", endpoint.getOs());//操作系统
        parameter.put("devm", endpoint.getDeviceModel());//设备类型
        parameter.put("brand", endpoint.getDeviceBrand());//设备品牌
        parameter.put("net_type", endpoint.getNetType());//联网方式,0:未知, 1:wifi, 2:数据网络-未知, 3:2G, 4:3G, 5:4G, 6:5G
        parameter.put("lon", endpoint.getLongitude());//经度
        parameter.put("lat", endpoint.getLatitude());//纬度
        parameter.put("dspid", endpoint.getDspId());//广告平台ID
        parameter.put("createid", endpoint.getCreateId());//创意ID
        if(null != endpoint.getWinPrice()){
            parameter.put("price", (endpoint.getWinPrice()));//赢价价格(厘)
        }
        parameter.put("status", endpoint.getStatus());//状态
        parameter.put("mac", endpoint.getMac());//mac地址
        parameter.put("activityid", endpoint.getActivityId());//活动ID
        parameter.put("scene", endpoint.getSceneType());//投放场景类型
        parameter.put("x", endpoint.getXDown());//按下X坐标
        parameter.put("y", endpoint.getYDown());//按下X坐标
        parameter.put("x_up", endpoint.getYUp());//弹起X坐标
        parameter.put("y_up", endpoint.getYUp());//弹起Y坐标
        parameter.put("reqpw", endpoint.getReqpw());//广告请求中的广告位宽
        parameter.put("reqph", endpoint.getReqph());//广告请求中的广告位高
        parameter.put("actpw", endpoint.getActpw());//实际广告位的宽
        parameter.put("actph", endpoint.getActph());//实际广告位的高
        parameter.put("vi_duration", endpoint.getViDuration());//视频总时长,单位秒
        if(log.isDebugEnabled()){
            log.debug("dot:{}", JsonHelper.convert(parameter));
        }
        asyncDot.asyncDotGet(parameter);
    }
}
