package com.bxm.adxcounter.service.listeners.adx;

import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.listeners.AdxDotSupport;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.events.adx.AdxGeneralEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * ADX埋点-通用<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:11
 */
@Slf4j
@Service
public class AdxGeneralDotEventListener extends AdxDotSupport implements EventListener<AdxGeneralEvent> {

    @Override
    @Subscribe
    public void consume(AdxGeneralEvent event) {
        DotMtEnum[] dotMtEnums = event.getDotMtEnums();
        if(null == dotMtEnums){
            log.warn("dotMtEnums is null");
            return ;
        }
        AdxEndpoint endpoint = event.getEndpoint();
        super.consume(dotMtEnums, endpoint);
    }
}
