package com.bxm.adxcounter.service.listeners.adx;

import com.bxm.warcar.cache.Updater;
import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.events.adx.AdxGeneralEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author allen
 * @date 2020-10-29
 * @since 1.0
 */
@Service
public class ShowStatisticsEventListener implements EventListener<AdxGeneralEvent> {

    private final Counter counter;
    private final Updater updater;

    public ShowStatisticsEventListener(Counter counter, Updater updater) {
        this.counter = counter;
        this.updater = updater;
    }

    @Override
    @Subscribe
    public void consume(AdxGeneralEvent event) {
        AdxEndpoint endpoint = event.getEndpoint();
        DotMtEnum[] dotMtEnums = event.getDotMtEnums();
        for (DotMtEnum dotMtEnum : dotMtEnums) {
            if (dotMtEnum == DotMtEnum._15005) {
                handleWithPerDay(endpoint);
                handleWithUid(endpoint);
            }
        }
    }

    private void handleWithPerDay(AdxEndpoint endpoint) {
        String positionId = endpoint.getPositionId();
        String dspId = endpoint.getDspId();

        KeyGenerator key = () -> KeyBuilder.build("statistics", "adx", "show", DateHelper.getDate(), positionId);
        counter.hincrementAndGet(key, dspId);

        // 广告位每人每天曝光次数,ADX广告位限制中会用到
        KeyGenerator userShowCount = () -> KeyBuilder.build("statistics", "adx", "show", "user", DateHelper.getDate(), positionId);
        counter.hincrementAndGet(userShowCount, endpoint.getDevUid());

        //最后一次曝光时间,ADX 广告位限制中会用到
        KeyGenerator lasttime = () -> KeyBuilder.build("statistics", "adx", "show", "user", "lasttime", positionId, endpoint.getDevUid());
        updater.update(lasttime, System.currentTimeMillis());
    }

    private void handleWithUid(AdxEndpoint endpoint) {
        String positionId = endpoint.getPositionId();
        String dspId = endpoint.getDspId();

        String uid = endpoint.getDevUid();

        KeyGenerator key = () -> KeyBuilder.build("statistics", "adx", "show", DateHelper.getDate(), positionId, dspId, uid);

        counter.incrementAndGet(key, 24 * 60 * 60);
    }
}
