package com.bxm.adxcounter.service.listeners.sdk;

import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.listeners.SdkDotSupport;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.sdk.SdkGeneralEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * SDK埋点-通用<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:11
 */
@Slf4j
@Service
public class SdkGeneralDotEventListener extends SdkDotSupport implements EventListener<SdkGeneralEvent> {

    @Override
    @Subscribe
    public void consume(SdkGeneralEvent event) {
        DotMtEnum[] dotMtEnums = event.getDotMtEnums();
        if(null == dotMtEnums){
            log.warn("dotMtEnums is null");
            return ;
        }
        SdkEndpoint endpoint = event.getEndpoint();
        super.consume(dotMtEnums, endpoint);
    }
}
