package com.bxm.adxcounter.service.listeners.sdk;

import java.util.Date;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adxcounter.integration.user.UserIntegration;
import com.bxm.adxcounter.service.common.Constant;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.listeners.SdkDotSupport;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.sdk.SdkViewEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.StringHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * SDK埋点-SDK广告曝光<br/>
 *
 * @author kerry.jiang
 * @date 2020/07/02 15:10
 */
@Slf4j
@Service
public class SdkViewDotEventListener extends SdkDotSupport implements EventListener<SdkViewEvent> {

    @Autowired
    @Qualifier("jedisCounter")
    private Counter counter;

    @Resource
    private UserIntegration userIntegration;

    @Override
    @Subscribe
    public void consume(SdkViewEvent event) {
        SdkEndpoint endpoint = event.getEndpoint();
        if(!StringHelper.isNewVersion(SdkVersionEnum.SUPPORT_FREQUENCY_243.getVersion(), endpoint.getSdkVersion())){
            //sdk-2.4.3之前的版本,其曝光无需存redis,这些版本不支持SDK调度频次控制
            return ;
        }

        String positionId = endpoint.getPositionId();
        String devNo = AdxEndpointHandle.getUid(userIntegration, endpoint);
        String dmy = DateHelper.format(new Date(), DateHelper.PATTERN_STR8);
        String thirdSdkType = endpoint.getThirdSdkType();

        //设备按日
        {
            //Key
            KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getSdk(positionId, dmy, devNo);
            //增加 曝光量
            counter.hincrementAndGet(keyGenerator, thirdSdkType, Constant.EXPIRE_SDK_DAY);
        }
    }
}
