package com.bxm.adxcounter.service.listeners.sdk;

import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.integration.user.UserIntegration;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.sdk.SdkGeneralEvent;
import com.bxm.adxcounter.service.service.UserService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @date 2020-07-10
 * @since 1.0
 */
@Slf4j
@Service
public class UserPlayVideoFinishedEventListener implements EventListener<SdkGeneralEvent> {

    private final UserService userService;
    private final UserIntegration userIntegration;

    public UserPlayVideoFinishedEventListener(UserService userService, UserIntegration userIntegration) {
        this.userService = userService;
        this.userIntegration = userIntegration;
    }

    @Override
    @Subscribe
    public void consume(SdkGeneralEvent event) {
        SdkEndpoint endpoint = event.getEndpoint();
        DotMtEnum[] dotMtEnums = event.getDotMtEnums();
        for (DotMtEnum dotMtEnum : dotMtEnums) {
            if (dotMtEnum != DotMtEnum._16008) {
                continue;
            }

            // do something...
            String positionId = endpoint.getPositionId();
            String uid = AdxEndpointHandle.getUid(userIntegration, endpoint);
            userService.plusPayVideoFinished(positionId, uid);
        }
    }
}
