package com.bxm.adxcounter.service.listeners.task;

import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.listeners.TaskDotSupport;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.task.TaskGeneralEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * 任务埋点-通用<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/2 16:24
 */
@Slf4j
@Service
public class TaskGeneralDotEventListener extends TaskDotSupport implements EventListener<TaskGeneralEvent> {

    @Override
    @Subscribe
    public void consume(TaskGeneralEvent event) {
        DotMtEnum[] dotMtEnums = event.getDotMtEnums();
        if(null == dotMtEnums){
            log.warn("dotMtEnums is null");
            return ;
        }
        TaskEndpoint endpoint = event.getEndpoint();
        super.consume(dotMtEnums, endpoint);
    }
}
