package com.bxm.adxcounter.service.listeners.task;

import javax.annotation.Resource;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.constant.redis.TaskCounterField;
import com.bxm.adx.facade.rule.task.Task;
import com.bxm.adxcounter.integration.user.UserIntegration;
import com.bxm.adxcounter.integration.mccms.TaskIntegration;
import com.bxm.adxcounter.service.common.Constant;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.listeners.TaskDotSupport;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.task.TaskViewEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 任务埋点-曝光<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/31 20:45
 */
@Slf4j
@Service
public class TaskViewEventListener extends TaskDotSupport implements EventListener<TaskViewEvent> {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    @Qualifier("jedisCounter")
    private Counter counter;

    @Resource
    private UserIntegration userIntegration;
    @Resource
    private TaskIntegration taskIntegration;

    @Override
    @Subscribe
    public void consume(TaskViewEvent event) {
        TaskEndpoint endpoint = event.getEndpoint();
        String taskIdStr = endpoint.getTaskId();
        String devNo = AdxEndpointHandle.getUid(userIntegration, endpoint);

        if(StringUtils.isEmpty(taskIdStr)){
            log.warn("taskIdStr is empty！appId={}", endpoint.getAppId());
            return ;
        }
        //任务原始信息
        Task task = fetcher.hfetch(AdxKeyGenerator.Task.getAllList(), taskIdStr, Task.class);
        if (task == null){
            log.warn("任务信息（{}）为空！", taskIdStr);
            return ;
        }
        if (Task.STATUS_OPEN != task.getStatus()){
            log.warn("任务信息（{}）不是开启状态，无需统计！", taskIdStr);
            return ;
        }
        Long taskId = Long.valueOf(taskIdStr);
        String dmy = DateHelper.format(new Date(), DateHelper.PATTERN_STR8);
        //任务总计
        {
            KeyGenerator taskKeyGenerator = AdxKeyGenerator.Task.getCounter(taskId);
            //增加 曝光量
            Long views = counter.hincrementAndGet(taskKeyGenerator, TaskCounterField.VIEWS);
            if(null == task.getViewTotalLimit() || task.getViewTotalLimit() < 1){
                //不限
            }else if(views >= task.getViewTotalLimit()){
                //调用mccms暂停任务
                taskIntegration.updateStatus(taskId, Task.STATUS_PAUSE, Task.PAUSE_REASON_VIEW_TOTAL_LIMIT);
            }
        }
        //任务按日
        {
            //Key
            KeyGenerator taskKeyGenerator = AdxKeyGenerator.Task.getCounter(taskId, dmy);
            //增加 曝光量
            Long views = counter.hincrementAndGet(taskKeyGenerator, TaskCounterField.VIEWS, Constant.EXPIRE_TASK_DAY);
            if(null == task.getViewDayLimit() || task.getViewDayLimit() < 1){
                //不限
            }else if(views >= task.getViewDayLimit()){
                //调用mccms暂停任务
                taskIntegration.updateStatus(taskId, Task.STATUS_PAUSE, Task.PAUSE_REASON_VIEW_DAY_LIMIT);
            }
        }
        //设备按日
        {
            //Key
            KeyGenerator taskKeyGenerator = AdxKeyGenerator.Task.getCounter(taskId, dmy, devNo);
            //增加 曝光量
            counter.hincrementAndGet(taskKeyGenerator, TaskCounterField.VIEWS, Constant.EXPIRE_TASK_DAY);
        }

        //打点
        super.consume(event.getDotMtEnums(), endpoint);
    }
}
