package com.bxm.adxcounter.service.model.endpoint;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 打点参数-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 14:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AdxEndpoint extends AbstractEndpoint {

    private static final long serialVersionUID = -6721458464992101143L;

    /**
     * 变现猫竞价ID
     */
    private String bxmBidId;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 广告平台ID
     */
    private String dspId;
    /**
     * 创意ID
     */
    private String createId;
    /**
     * 本次赢价（单位：厘）
     */
    private Double winPrice;
    /**
     * 状态
     */
    private String status;
    /**
     * 活动ID
     */
    private String activityId;
    /**
     * 投放场景类型
     */
    private String sceneType;
    /**
     * 点击事件鼠标或手指按下时相对于素材的 X 坐标
     */
    private String xDown;
    /**
     * 点击事件鼠标或手指按下时相对于素材的 Y坐标
     */
    private String yDown;
    /**
     * 点击事件鼠标或手指弹起时相对于素材的 X 坐标
     */
    private String xUp;
    /**
     * 点击事件鼠标或手指弹起时相对于素材的 Y 坐标
     */
    private String yUp;
    /**
     * 广告请求中的广告位宽，单位像素
     */
    private String reqpw;
    /**
     * 广告请求中的广告位高，单位像素
     */
    private String reqph;
    /**
     * 实际广告位的宽，单位像素
     */
    private String actpw;
    /**
     * 实际广告位的高，单位像素
     */
    private String actph;
    /**
     * 视频总时长,单位秒
     */
    private String viDuration;
}
