package com.bxm.adxcounter.service.model.events.adx;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.events.NoneListenerEvent;

import lombok.Getter;

/**
 * 埋点事件-ADX通用<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 15:10
 */
public class AdxGeneralEvent extends NoneListenerEvent {

    private static final long serialVersionUID = -3357221270145808049L;

    @Getter
    private final AdxEndpoint endpoint;
    @Getter
    private final DotMtEnum[] dotMtEnums;

    public AdxGeneralEvent(Object source, AdxEndpoint endpoint, DotMtEnum... dotMtEnums) {
        super(source);
        this.endpoint = endpoint;
        this.dotMtEnums = dotMtEnums;
    }
}