package com.bxm.adxcounter.service.model.events.task;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.NoneListenerEvent;

import lombok.Getter;

/**
 * 埋点事件-该事件不做任何监听<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/2 15:54
 */
public class TaskNoneListenerEvent extends NoneListenerEvent {

    private static final long serialVersionUID = -3357221270145808049L;

    @Getter
    private final TaskEndpoint endpoint;
    @Getter
    private final DotMtEnum[] dotMtEnums;

    public TaskNoneListenerEvent(Object source, TaskEndpoint endpoint, DotMtEnum... dotMtEnums) {
        super(source);
        this.endpoint = endpoint;
        this.dotMtEnums = dotMtEnums;
    }
}