package com.bxm.adxcounter.service.service;

import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import org.springframework.http.ResponseEntity;

import com.bxm.adxcounter.facade.constant.SdkMtEnum;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;

/**
 * 端点服务-SDK<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:46
 */
public interface SdkEndpointService {

    /**
     * 提交端点统计请求
     *
     * @param endpoint endpoint
     * @return 返回对象
     */
    ResponseEntity init(SdkEquipmentDTO endpoint);

    /**
     * 绑定扩展参数
     * @param endpoint endpoint
     */
    void extBind(SdkPublicDTO endpoint);

    /**
     * 提交端点统计请求
     *
     * @param mtEnum mt值
     * @param endpoint 打点信息
     * @return 返回对象
     */
    ResponseEntity post(SdkMtEnum mtEnum, SdkEndpoint endpoint);
}
