package com.bxm.adxcounter.service.service.impl;

import com.bxm.adxcounter.facade.constant.SdkMtEnum;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.adxcounter.service.model.events.sdk.SdkEquipmentEvent;
import com.bxm.adxcounter.service.model.events.sdk.SdkExtBindEvent;
import com.bxm.adxcounter.service.model.events.sdk.SdkGeneralEvent;
import com.bxm.adxcounter.service.model.events.sdk.SdkViewEvent;
import com.bxm.adxcounter.service.service.SdkEndpointService;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * 端点服务-SDK<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:46
 */
@Slf4j
@Service
public class SdkEndpointServiceImpl extends AbstractEndpointServiceImpl implements SdkEndpointService {

    @Autowired
    @Qualifier("customizingAsyncEventPark")
    private AsyncEventPark customizingAsyncEventPark;

    @Override
    public ResponseEntity init(SdkEquipmentDTO endpoint) {
        customizingAsyncEventPark.post(new SdkEquipmentEvent(this, endpoint));
        return ResponseEntity.ok().build();
    }

    @Override
    public void extBind(SdkPublicDTO endpoint) {
        asyncEventPark.post(new SdkExtBindEvent(this, endpoint));
    }

    @Override
    public ResponseEntity post(SdkMtEnum mtEnum, SdkEndpoint endpoint) {
        switch (mtEnum) {
            case _OTHER: {
                //非法埋点
                return ResponseEntity.badRequest().body("mt不匹配");
            }
            case _105: {
                //第三方广告曝光
                asyncEventPark.post(new SdkViewEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            }
            default: {
                //不做任何处理的埋点
                asyncEventPark.post(new SdkGeneralEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            }
        }
        return ResponseEntity.ok().build();
    }
}
