package com.bxm.adxcounter.service.service.impl;

import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;
import com.bxm.adxcounter.service.model.events.task.*;
import com.bxm.adxcounter.service.service.TaskEndpointService;

import lombok.extern.slf4j.Slf4j;

/**
 * 端点服务-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:46
 */
@Slf4j
@Service
public class TaskEndpointServiceImpl extends AbstractEndpointServiceImpl implements TaskEndpointService {
    
    @Override
    public ResponseEntity post(AdxMtEnum mtEnum, TaskEndpoint endpoint) {
        switch (mtEnum) {
            case _OTHER: {
                //非法埋点
                return ResponseEntity.badRequest().body("mt不匹配");
            }
            case _201:
                asyncEventPark.post(new TaskAcquireEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            case _202:
                asyncEventPark.post(new TaskViewEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            case _203:
                asyncEventPark.post(new TaskClickEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            case _204:
                asyncEventPark.post(new TaskReadyEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            case _205:
                asyncEventPark.post(new TaskWakeEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            case _206:
                asyncEventPark.post(new TaskSucceedEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            default: {
                //不做任何处理的埋点
                asyncEventPark.post(new TaskGeneralEvent(this, endpoint, mtEnum.getDotMtEnums()));
                break;
            }
        }
        return ResponseEntity.ok().build();
    }
}
