package com.bxm.adxcounter.service.service.impl;

import com.bxm.adxcounter.facade.model.UserData;
import com.bxm.adxcounter.facade.service.UserFacadeService;
import com.bxm.adxcounter.service.service.UserService;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author allen
 * @date 2020-07-17
 * @since 1.0
 */
@RestController
public class UserFacadeServiceImpl implements UserFacadeService {

    private final UserService userService;

    public UserFacadeServiceImpl(UserService userService) {
        this.userService = userService;
    }

    @Override
    public List<UserData> getUserData(String appId, String[] cuids, String date) {
        return userService.getPayVideoFinishedByAppId(appId, cuids, date);
    }
}
