package com.bxm.adx.plugins.jd.filter;

import com.bxm.adx.plugins.deeplink.common.filter.AbstractUserShowLimitingPerDayFilter;
import com.bxm.adx.plugins.jd.JdPluginConfig;
import com.bxm.warcar.cache.Counter;
import org.springframework.stereotype.Service;

/**
 * @author allen
 * @date 2020-11-05
 * @since 1.0
 */
@Service
public class UserShowLimitingPerDayFilter extends AbstractUserShowLimitingPerDayFilter {

    private final Counter counter;
    private final JdPluginConfig config;

    public UserShowLimitingPerDayFilter(Counter counter, JdPluginConfig config) {
        this.counter = counter;
        this.config = config;
    }

    @Override
    protected Counter getCounter() {
        return counter;
    }

    @Override
    protected int getLimitingShowPerDayOfUser() {
        return config.getLimitingShowPerDayOfUser();
    }
}
