package com.bxm.adxcounter.facade.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 公共参数<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 13:53
 */
@Data
public abstract class AbstractCounterDTO implements Serializable {

    private static final long serialVersionUID = -4805979249918133754L;

    public static final String OS_UNKNOWN = "0";
    public static final String OS_ANDROID = "1";
    public static final String OS_IOS = "2";

    /**
     * 以太网
     */
    public static final String NET_UNKNOWN = "0";
    public static final String NET_ETHERNET = "1";
    public static final String NET_WIFI = "2";
    public static final String NET_2G = "3";
    public static final String NET_3G = "4";
    public static final String NET_4G = "5";
    public static final String NET_5G = "6";
    /**
     * 蜂窝数据网络-未知
     */
    public static final String NET_NG = "7";

    /**
     * 时间戳（timestamp）
     */
    private String t;
    /**
     * 用户IP地址
     */
    private String ip;
    /**
     * User-Agent
     */
    private String ua;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * 系统类型
     * 0:未知
     * 1:安卓
     * 2:IOS
     */
    private String os;
    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * IMEI，所属安卓
     */
    private String imei_md5;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 安卓ID
     */
    private String anid_md5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * IDFA，所属IOS
     */
    private String idfa_md5;
    /**
     * Google Advertising ID
     */
    private String gaid;
    /**
     * Google Advertising ID
     */
    private String gaid_md5;
    /**
     * 设备品牌（deviceBrand）,如：华为
     */
    private String devb;
    /**
     * 设备型号（deviceModel）,如：华为 mate 10 pro
     */
    private String devm;
    /**
     * 联网方式（netType）
     * 0:未知
     * 1:以太网
     * 2:Wifi网络
     * 3:蜂窝数据网络-2G
     * 4:蜂窝数据网络-3G
     * 5:蜂窝数据网络-4G
     * 6:蜂窝数据网络-5G
     * 7:蜂窝数据网络-未知
     */
    private String net;
    /**
     * 经度（longitude）
     */
    private String lon;
    /**
     * 纬度（latitude）
     */
    private String lat;
}
