package com.bxm.adxcounter.facade.constant;

/**
 * 数据中心打点枚举<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 10:50
 */
public enum DotMtEnum {

    /** 不明的 */
    _OTHER(-99),
    
    //-------------------------------  常规埋点  --------------------------------
    /** ADX竞价请求 */
    _15001(15001),
    /** 分发DSP请求 */
    _15002(15002),
    /** 分发DSP响应 */
    _15003(15003),
    /** ADX竞价响应 */
    _15004(15004),
    /** 创意曝光 */
    _15005(15005),
    /** 创意点击 */
    _15006(15006),
    /** 唤醒完成 */
    _15007(15007),
    /** 任务下发 */
    _15008(15008),
    /** 曝光 */
    _15009(15009),
    /** 点击 */
    _15010(15010),
    /** 准备就绪 */
    _15011(15011),
    /** 唤醒成功 */
    _15012(15012),
    /** 任务请求 */
    _15013(15013),
    /** 任务填充 */
    _15014(15014),

    //------------------------------  视频类埋点  -------------------------------
    /** 开始播放 */
    _15101(15101),
    /** 播放至1/4 */
    _15102(15102),
    /** 播放至1/2 */
    _15103(15103),
    /** 播放至3/4 */
    _15104(15104),
    /** 播放完成 */
    _15105(15105),
    /** 开启静音播放（用户行为触发，默认行为不上报） */
    _15106(15106),
    /** 视频跳过 */
    _15107(15107),
    /** 视频关闭(客户端释放播放资源) */
    _15108(15108),
    /** 播放暂停 */
    _15109(15109),
    /** 继续播放 */
    _15110(15110),
    /** 开启全屏播放（用户行为触发，默认行为不上报） */
    _15111(15111),
    /** 关闭全屏播放（用户行为触发，默认行为不上报） */
    _15112(15112),
    /** 关闭静音播放（用户行为触发，默认行为不上报） */
    _15113(15113),
    /** 视频离开(用户切换界面，播放进度仍保留) */
    _15114(15114),
    /** 放弃奖励(放弃奖励) */
    _15115(15115),
    /** 结束页曝光 */
    _15501(15501),
    /** 返回拦截曝光 */
    _15502(15502),
    //------------------------------  安卓下载类  -------------------------------
    /** 开始下载应用 */
    _15201(15201),
    /** 下载应用完成 */
    _15202(15202),
    /** 开始安装应用 */
    _15203(15203),
    /** 应用安装完成 */
    _15204(15204),
    /** 激活,安装完成后直接启动App */
    _15205(15205),

    //------------------------------  deeplink  -------------------------------
    /** deeplink唤起开始 */
    _15301(15301),
    /** deeplink唤起成功 */
    _15302(15302),
    /** deeplink唤起失败 */
    _15303(15303),

    //------------------------------  失败  -------------------------------
    /** 曝光失败 */
    _15401(15401),
    /** 点击失败 */
    _15402(15402),

    //------------------------------  SDK健康监测  -------------------------------
    /** 调度接口请求 **/
    _16001(16001),
    /** 调度接口响应 **/
    _16002(16002),
    /** sdk执行xx请求 **/
    _16003(16003),
    /** sdk执行xx请求超时 **/
    _16004(16004),
    /** 初始化成功 **/
    _16005(16005),
    /** 第三方广告曝光 **/
    _16006(16006),
    /** 第三方广告点击 **/
    _16007(16007),
    /** 第三方视频播放完成 **/
    _16008(16008),

    //------------------------------  弱网环境  -------------------------------
    /** 视频无法播放，跳转到结束页 **/
    _17011(17011),
    ;

    /**
     * 数据中心MT值
     */
    private int dotMt;

    DotMtEnum(int dotMt) {
        this.dotMt = dotMt;
    }

    public int getDotMt() {
        return dotMt;
    }
}
