/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.bxm.app.dal.mapper.ext.AppAdPositionConfigMapperExt;
import com.bxm.app.dal.mapper.ext.AppEntranceFacadeMapperExt;
import com.bxm.app.dal.mapper.ext.ProviderAppMapperExt;
import com.bxm.app.dal.model.AppAdPositionConfig;
import com.bxm.app.dal.model.AppEntrance;
import com.bxm.app.model.dto.QueryAppAdPositionConfigDto;
import com.bxm.app.model.vo.AppAdPositionConfigVo;
import com.bxm.util.dto.ValidateException;
import com.bxm.util.enums.YesOrNo;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppAdPositionConfigService {
    @Autowired
    private AppAdPositionConfigMapperExt appAdPositionConfigMapperExt;
    @Autowired
    private AppEntranceFacadeMapperExt appEntranceFacadeMapperExt;
    @Autowired
    private ProviderAppMapperExt providerAppMapperExt;

    public PageInfo<AppAdPositionConfigVo> getPageList(QueryAppAdPositionConfigDto queryAppAdPositionConfigDto) throws ValidateException, Exception {
        return new PageInfo(this.appAdPositionConfigMapperExt.getList(queryAppAdPositionConfigDto));
    }

    public String getAdPositionIdByParams(Integer productId, Integer appId, String bxmMediaAppKey, String resPositionName) throws ValidateException, Exception {
        String appAdPosition = this.appAdPositionConfigMapperExt.getByParams(productId, appId, resPositionName);
        if (appAdPosition == null) {
            Integer appEntranceId = this.appAdPositionConfigMapperExt.findAppEntraceIdByAppKey(bxmMediaAppKey);
            appEntranceId = appEntranceId == null ? 2 : appEntranceId + 1;
            String adPositionId = bxmMediaAppKey + "-" + appEntranceId;
            AppEntrance appEntrance = new AppEntrance();
            appEntrance.setAppEntranceId(appEntranceId + "");
            appEntrance.setDockingMethod(Integer.valueOf(0));
            appEntrance.setAppEntranceName(resPositionName);
            appEntrance.setState(Integer.valueOf(1));
            appEntrance.setAppKey(bxmMediaAppKey);
            appEntrance.setCreated(new Date());
            appEntrance.setPositionId(adPositionId);
            appEntrance.setProductId(Integer.valueOf(4));
            appEntrance.setIsDeleted(YesOrNo.NO.getValue());
            this.appEntranceFacadeMapperExt.insertSelective(appEntrance);
            AppAdPositionConfig appAdPositionConfig = new AppAdPositionConfig();
            appAdPositionConfig.setAppId(appId);
            appAdPositionConfig.setProductId(productId);
            appAdPositionConfig.setResPositionName(resPositionName);
            appAdPositionConfig.setAdPositionId(adPositionId);
            this.appAdPositionConfigMapperExt.insertSelective(appAdPositionConfig);
            return adPositionId;
        }
        return appAdPosition;
    }
}

